#ifndef PARSER_DEFS_H
#define PARSER_DEFS_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:44:53 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version parser_err.h#1:incl:12
   *  \author avis
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/
            
#define DX_SEP_PARSER_MAX_NUM_OF_LLI_ENTRIES			0x20
    
#define DX_SEP_LLI_TABLE_IN_MODE		                0x1
#define DX_SEP_LLI_TABLE_OUT_MODE		                0x2
#define DX_SEP_LLI_TABLE_IN_OUT_MODE	                0x3    
    
/************************ Enums ********************************/

/* The enum determining the type of context to be allocated using the CRYS_CCM_GetContext function or released
   using the CRYS_CCM_ReleaseContext function */

typedef enum 
{

	 DX_SEP_PARSER_HASH_MD5_CONTEXT   ,
	 DX_SEP_PARSER_HASH_SHA1_CONTEXT  ,
	 DX_SEP_PARSER_HMAC_CONTEXT,
	 DX_SEP_PARSER_DES_1KEY_CONTEXT   ,
	 DX_SEP_PARSER_DES_2KEY_CONTEXT   ,
	 DX_SEP_PARSER_DES_3KEY_CONTEXT   ,
	 DX_SEP_PARSER_RSA_SIGN_CONTEXT   ,
	 DX_SEP_PARSER_RSA_VERIFY_CONTEXT ,
	 DX_SEP_PARSER_AES_CONTEXT,
	 DX_SEP_PARSER_AESCCM_CONTEXT,
	 DX_SEP_PARSER_RC4_CONTEXT,
 	 DX_SEP_PARSER_ECDSA_SIGN_CONTEXT,
	 DX_SEP_PARSER_ECDSA_VERIFY_CONTEXT,
	 DX_SEP_PARSER_OTF_CONTEXT,
	 DX_SEP_PARSER_C2_CONTEXT


}DX_SEP_PARSER_ContextType_t;

/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/
 
 /* ------------------------------------------------------------
 **
 * @brief This function does the following:
 *        1) Cast the pointers to userContext (one from the HOST and one from the SEP. 
 *        2) Check the IV if it is equal the current SEP context is the same as the HOST.
 *        3) decrypt the context from the HOST buffer to the SEP buffer.
 *        
 *
 * @param[in] EncContext_ptr - The user context has received from the HOST .
 * @param[in] DecContext_ptr - The local buffer for the SEP (in the SEP SRAM).
 * @param[in] ContextType_t - type of context.
 *
 * @return CRYSError_t - On success CRYS_OK.
 */

 DxUint32_t DX_SEP_PARSER_DecContext(void *EncContext_ptr,
									 void * DecContext_ptr,
									 DX_SEP_PARSER_ContextType_t Type);
 /* ------------------------------------------------------------
 **
 * @brief This function does the following:
 *        1) Encrypes the information in the active context.
 *        2) copies the information to the users context.
 *        3) Frees the CCM active context.
 *        4) Frees the semaphore protecting the active context.    
 *
 * @param[in] UserContext_ptr - The users context pointer.
 * @param[out] Type - The context type.
 *
 * @return CRYSError_t - On success CRYS_OK.
 */
 
 DxUint32_t DX_SEP_PARSER_EncContext(void *EncContext_ptr,
									 void * DecContext_ptr,
									 DX_SEP_PARSER_ContextType_t Type, 
									 DxBool_t newIV);

/* ------------------------------------------------------------
 **
 * @brief This function initializes the CRYS module in cold init.
 *        it is called from the CRYS_INIT function.    
 *
 *
 * @return CRYSError_t - On success CRYS_OK.
 */
 
 DxUint32_t DX_SEP_PARSER_Init(DxUint8_t * sharedAreaAddr, DxUint32_t sharedAreaSize );



#ifdef __cplusplus
}
#endif

#endif

